import sys
from collections import defaultdict

input = sys.stdin.readline

n = int(input())

diag1 = defaultdict(int)
diag2 = defaultdict(int)

same_x = defaultdict(lambda: [0, 0])
same_y = defaultdict(lambda: [0, 0])

points = []

for _ in range(n):
    x, y = map(int, input().split())
    points.append((x, y))
    diag1[x - y] += 1
    diag2[x + y] += 1
    same_x[x][y & 1] += 1
    same_y[y][x & 1] += 1

ans = 0

for k in diag1.values():
    ans += k * (k - 1)

for k in diag2.values():
    ans += k * (k - 1)

for even, odd in same_x.values():
    ans += even * (even - 1) // 2
    ans += odd * (odd - 1) // 2

for even, odd in same_y.values():
    ans += even * (even - 1) // 2
    ans += odd * (odd - 1) // 2

print(ans)